---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, cellules, 
              grand texte dans un tableau, texte qui atteint le bord
---

# Comment éviter que du texte de grande taille ne touche le cadre des cellules ?

## Avec les commandes de base

### En étirant le tableau

Vous pouvez "dilater" l'espace autour du texte dans un tableau, 
en augmentant la valeur retournée par la commande `\arraystretch` 
(qui vaut 1 par défaut).

Voici un exemple illustrant cette méthode avec une correction de 1,5.

::::{tab-set}

:::{tab-item} Sans correction
```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
%
\begin{tabular}{|l|}
   \hline
   {\large HAUT} bas \\
   \hline
\end{tabular}
\end{document}
```
:::

:::{tab-item} Avec correction

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\renewcommand{\arraystretch}{1.5}
\begin{tabular}{|l|}
   \hline
   {\large HAUT} bas \\
   \hline
\end{tabular}
\end{document}
```
:::

::::


## En plaçant un élément invisible

Si vous avez changé de police dans un tableau (ou simplement de taille 
de police), il se peut que la hauteur de la cellule n'ait pas augmenté 
en conséquence. Vous pouvez alors utiliser la commande `\strut`, 
qui crée un caractère invisible (d'épaisseur nulle, en fait) qui s'adapte
à la taille de la fonte. Voici un exemple qui montre la différence 
que cela apporte :

::::{tab-set}

:::{tab-item} Sans correction
```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{tabular}{|l|}
   \hline
   {\large HAUT} bas \\
   \hline
\end{tabular}
\end{document}
```
:::

:::{tab-item} Avec correction

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\begin{tabular}{|l|}
   \hline
   {\large\strut HAUT} bas \\
   \hline
\end{tabular}
\end{document}
```
:::

::::


## Avec l'extension <ctanpkg:tabularray>

:::{todo} Ajouter un exemple.
:::