---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, notes marginales, note dans la marge de gauche, 
              note dans la marge de droite
---

# Comment mettre une note dans la marge ?

La commande par défaut pour obtenir une note marginale est 
`\marginpar{⟨texte de la note⟩}`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
La valeur du paramètre temps est fixée à 12~minutes\marginpar{AC}. 
En tenant compte de cette hypothèse, les résultats obtenus sont 
les suivants : \ldots
\end{document}
```

Pour inverser les notes dans les marges (droite/gauche),
il suffit de mettre dans le préambule la commande `\reversemarginpar` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \reversemarginpar

\begin{document}
La valeur du paramètre temps est fixée à 12~minutes\marginpar{AC}. 
En tenant compte de cette hypothèse, les résultats obtenus sont
les suivants : \ldots
\end{document}
```


:::{sources}
- [How do I get margin notes to appear on the left?](https://tex.stackexchange.com/q/14527), 
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::