## TFSA-2021-040: Heap OOB in `QuantizeAndDequantizeV3`

### CVE Number
CVE-2021-29553

### Impact
An attacker can read data outside of bounds of heap allocated buffer in
`tf.raw_ops.QuantizeAndDequantizeV3`:

```python
import tensorflow as tf

tf.raw_ops.QuantizeAndDequantizeV3(
  input=[2.5,2.5], input_min=[0,0], input_max=[1,1], num_bits=[30],
  signed_input=False, range_given=False, narrow_range=False, axis=3)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/11ff7f80667e6490d7b5174aa6bf5e01886e770f/tensorflow/core/kernels/quantize_and_dequantize_op.cc#L237)
does not validate the value of user supplied `axis` attribute before using it to
index in the array backing the `input` argument:

```cc
const int depth = (axis_ == -1) ? 1 : input.dim_size(axis_);
```

### Patches
We have patched the issue in GitHub commit
[99085e8ff02c3763a0ec2263e44daec416f6a387](https://github.com/tensorflow/tensorflow/commit/99085e8ff02c3763a0ec2263e44daec416f6a387).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Aivul Team from Qihoo 360.
