% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devices.R
\name{devices}
\alias{devices}
\alias{with_dev}
\alias{with_device}
\alias{with_bmp}
\alias{local_bmp}
\alias{with_cairo_pdf}
\alias{local_cairo_pdf}
\alias{with_cairo_ps}
\alias{local_cairo_ps}
\alias{with_pdf}
\alias{local_pdf}
\alias{with_postscript}
\alias{local_postscript}
\alias{with_svg}
\alias{local_svg}
\alias{with_tiff}
\alias{local_tiff}
\alias{with_xfig}
\alias{local_xfig}
\alias{with_png}
\alias{local_png}
\alias{with_jpeg}
\alias{local_jpeg}
\title{Graphics devices}
\usage{
with_bmp(new, code, ...)

local_bmp(new, ..., .local_envir = parent.frame())

with_cairo_pdf(new, code, ...)

local_cairo_pdf(new, ..., .local_envir = parent.frame())

with_cairo_ps(new, code, ...)

local_cairo_ps(new, ..., .local_envir = parent.frame())

with_pdf(new, code, ...)

local_pdf(new, ..., .local_envir = parent.frame())

with_postscript(new, code, ...)

local_postscript(new, ..., .local_envir = parent.frame())

with_svg(new, code, ...)

local_svg(new, ..., .local_envir = parent.frame())

with_tiff(new, code, ...)

local_tiff(new, ..., .local_envir = parent.frame())

with_xfig(new, code, ...)

local_xfig(new, ..., .local_envir = parent.frame())

with_png(new, code, ...)

local_png(new, ..., .local_envir = parent.frame())

with_jpeg(new, code, ...)

local_jpeg(new, ..., .local_envir = parent.frame())
}
\arguments{
\item{new}{\code{[named character]}\cr New graphics device}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{...}{Additional arguments passed to the graphics device.}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Temporarily use a graphics device.
}
\details{
\itemize{
\item \code{with_bmp()} and \code{local_bmp()} wrap around \code{\link[grDevices:png]{grDevices::bmp()}}.
\item \code{with_cairo_pdf()} and \code{local_cairo_pdf()} wrap around \code{\link[grDevices:cairo]{grDevices::cairo_pdf()}}.
\item \code{with_cairo_ps()} and \code{local_cairo_ps()} wrap around \code{\link[grDevices:cairo]{grDevices::cairo_ps()}}.
\item \code{with_pdf()} and \code{local_pdf()} wrap around \code{\link[grDevices:pdf]{grDevices::pdf()}}.
\item \code{with_postscript()} and \code{local_postscript()} wrap around \code{\link[grDevices:postscript]{grDevices::postscript()}}.
\item \code{with_svg()} and \code{local_svg()} wrap around \code{\link[grDevices:cairo]{grDevices::svg()}}.
\item \code{with_tiff()} and \code{local_tiff()} wrap around \code{\link[grDevices:png]{grDevices::tiff()}}.
\item \code{with_xfig()} and \code{local_xfig()} wrap around \code{\link[grDevices:xfig]{grDevices::xfig()}}.
\item \code{with_png()} and \code{local_png()} wrap around \code{\link[grDevices:png]{grDevices::png()}}.
\item \code{with_jpeg()} and \code{local_jpeg()} wrap around \code{\link[grDevices:png]{grDevices::jpeg()}}.
}
}
\section{Functions}{
\itemize{
\item \code{with_bmp()}: BMP device

\item \code{with_cairo_pdf()}: CAIRO_PDF device

\item \code{with_cairo_ps()}: CAIRO_PS device

\item \code{with_pdf()}: PDF device

\item \code{with_postscript()}: POSTSCRIPT device

\item \code{with_svg()}: SVG device

\item \code{with_tiff()}: TIFF device

\item \code{with_xfig()}: XFIG device

\item \code{with_png()}: PNG device

\item \code{with_jpeg()}: JPEG device

}}
\examples{
# dimensions are in inches
with_pdf(file.path(tempdir(), "test.pdf"), width = 7, height = 5,
  plot(runif(5))
)

# dimensions are in pixels
with_png(file.path(tempdir(), "test.png"), width = 800, height = 600,
  plot(runif(5))
)
}
\seealso{
\code{\link{withr}} for examples

\code{\link[grDevices]{Devices}}
}
