# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.features.v2021_07_01.aio import FeatureClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestFeatureSubscriptionFeatureRegistrationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(FeatureClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_subscription_feature_registrations_get(self, resource_group):
        response = await self.client.subscription_feature_registrations.get(
            provider_namespace="str",
            feature_name="str",
            api_version="2021-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_subscription_feature_registrations_create_or_update(self, resource_group):
        response = await self.client.subscription_feature_registrations.create_or_update(
            provider_namespace="str",
            feature_name="str",
            api_version="2021-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_subscription_feature_registrations_delete(self, resource_group):
        response = await self.client.subscription_feature_registrations.delete(
            provider_namespace="str",
            feature_name="str",
            api_version="2021-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_subscription_feature_registrations_list_by_subscription(self, resource_group):
        response = self.client.subscription_feature_registrations.list_by_subscription(
            provider_namespace="str",
            api_version="2021-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_subscription_feature_registrations_list_all_by_subscription(self, resource_group):
        response = self.client.subscription_feature_registrations.list_all_by_subscription(
            api_version="2021-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
