<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# isCastingMode

> Test if an input value is a supported ndarray casting mode.

<!-- Section to include introductory text. Make sure to keep an empty line after the intro `section` element and another before the `/section` close. -->

<section class="intro">

</section>

<!-- /.intro -->

<!-- Package usage documentation. -->

<section class="usage">

## Usage

```javascript
var isCastingMode = require( '@stdlib/ndarray/base/assert/is-casting-mode' );
```

#### isCastingMode( value )

Tests if an input `value` is a supported ndarray casting mode.

```javascript
var bool = isCastingMode( 'safe' );
// returns true
```

</section>

<!-- /.usage -->

<!-- Package usage notes. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="notes">

</section>

<!-- /.notes -->

<!-- Package usage examples. -->

<section class="examples">

## Examples

<!-- eslint no-undef: "error" -->

```javascript
var isCastingMode = require( '@stdlib/ndarray/base/assert/is-casting-mode' );

var bool = isCastingMode( 'none' );
// returns true

bool = isCastingMode( 'equiv' );
// returns true

bool = isCastingMode( 'safe' );
// returns true

bool = isCastingMode( 'same-kind' );
// returns true

bool = isCastingMode( 'unsafe' );
// returns true

bool = isCastingMode( '' );
// returns false

bool = isCastingMode( 'foo' );
// returns false
```

</section>

<!-- /.examples -->

<!-- Section to include cited references. If references are included, add a horizontal rule *before* the section. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="references">

</section>

<!-- /.references -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

</section>

<!-- /.links -->
