// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Garay`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x010D40, 0x010D65],
    [0x010D69, 0x010D85],
    [0x010D8E, 0x010D8F]
  ]
});
testPropertyEscapes(
  /^\p{Script=Garay}+$/u,
  matchSymbols,
  "\\p{Script=Garay}"
);
testPropertyEscapes(
  /^\p{Script=Gara}+$/u,
  matchSymbols,
  "\\p{Script=Gara}"
);
testPropertyEscapes(
  /^\p{sc=Garay}+$/u,
  matchSymbols,
  "\\p{sc=Garay}"
);
testPropertyEscapes(
  /^\p{sc=Gara}+$/u,
  matchSymbols,
  "\\p{sc=Gara}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x010D3F],
    [0x010D66, 0x010D68],
    [0x010D86, 0x010D8D],
    [0x010D90, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Garay}+$/u,
  nonMatchSymbols,
  "\\P{Script=Garay}"
);
testPropertyEscapes(
  /^\P{Script=Gara}+$/u,
  nonMatchSymbols,
  "\\P{Script=Gara}"
);
testPropertyEscapes(
  /^\P{sc=Garay}+$/u,
  nonMatchSymbols,
  "\\P{sc=Garay}"
);
testPropertyEscapes(
  /^\P{sc=Gara}+$/u,
  nonMatchSymbols,
  "\\P{sc=Gara}"
);

reportCompare(0, 0);
