# mlpack Code of Conduct

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free experience for everyone, regardless of age, body
size, disability, ethnicity, sex characteristics, gender identity and
expression, level of experience, education, socio-economic status, nationality,
personal appearance, race, religion, or sexual identity and orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
  advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
  address, without explicit permission

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

## Scope

This Code of Conduct applies within all project spaces, and it also applies when
an individual is representing the project or its community in public spaces.
Examples of representing a project or community include using an official
project e-mail address, posting via an official social media account, or acting
as an appointed representative at an online or offline event. Representation of
a project may be further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at conduct@mlpack.org. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Reporting

If you believe someone is violating the code of conduct we ask that you report
it by emailing conduct@mlpack.org. All reports will be kept confidential. In
some cases we may determine that a public statement will need to be made. If
that's the case, the identities of all victims and reporters will remain
confidential unless those individuals instruct us otherwise.

If you are unsure whether the incident is a violation, or whether the space
where it happened is covered by this Code of Conduct, we encourage you to still
report it. We would much rather have a few extra reports where we decide to take
no action, rather than miss a report of an actual violation. We do not look
negatively on you if we find the incident is not a violation. And knowing about
incidents that are not violations, or happen outside our spaces, can also help
us to improve the Code of Conduct or the processes surrounding it.

In your report please include:

* Your contact info (so we can get in touch with you if we need to follow up)
* Names (real, nicknames, or pseudonyms) of any individuals involved. If there
  were other witnesses besides you, please try to include them as well.
* When and where the incident occurred. Please be as specific as possible.
* Your account of what occurred. If there is a publicly available record
  (e.g. a mailing list archive or a public IRC logger) please include a link.
* Any extra context you believe existed for the incident.
* If you believe this incident is ongoing.
* Any other information you believe we should have.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage],
version 1.4, available at
https://www.contributor-covenant.org/version/1/4/code-of-conduct.html, and
includes some aspects of the Drupal Code of Conduct.
