// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfrontkeyvaluestore

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cloudfrontkeyvaluestore/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpDeleteKey struct {
}

func (*validateOpDeleteKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeKeyValueStore struct {
}

func (*validateOpDescribeKeyValueStore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeKeyValueStore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeKeyValueStoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeKeyValueStoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetKey struct {
}

func (*validateOpGetKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListKeys struct {
}

func (*validateOpListKeys) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListKeys) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListKeysInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListKeysInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutKey struct {
}

func (*validateOpPutKey) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutKey) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutKeyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutKeyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateKeys struct {
}

func (*validateOpUpdateKeys) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateKeys) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateKeysInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateKeysInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpDeleteKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteKey{}, middleware.After)
}

func addOpDescribeKeyValueStoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeKeyValueStore{}, middleware.After)
}

func addOpGetKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetKey{}, middleware.After)
}

func addOpListKeysValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListKeys{}, middleware.After)
}

func addOpPutKeyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutKey{}, middleware.After)
}

func addOpUpdateKeysValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateKeys{}, middleware.After)
}

func validateDeleteKeyRequestListItem(v *types.DeleteKeyRequestListItem) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteKeyRequestListItem"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDeleteKeyRequestsList(v []types.DeleteKeyRequestListItem) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteKeyRequestsList"}
	for i := range v {
		if err := validateDeleteKeyRequestListItem(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePutKeyRequestListItem(v *types.PutKeyRequestListItem) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutKeyRequestListItem"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePutKeyRequestsList(v []types.PutKeyRequestListItem) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutKeyRequestsList"}
	for i := range v {
		if err := validatePutKeyRequestListItem(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteKeyInput(v *DeleteKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteKeyInput"}
	if v.KvsARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KvsARN"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.IfMatch == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IfMatch"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeKeyValueStoreInput(v *DescribeKeyValueStoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeKeyValueStoreInput"}
	if v.KvsARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KvsARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetKeyInput(v *GetKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetKeyInput"}
	if v.KvsARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KvsARN"))
	}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListKeysInput(v *ListKeysInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListKeysInput"}
	if v.KvsARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KvsARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutKeyInput(v *PutKeyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutKeyInput"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if v.KvsARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KvsARN"))
	}
	if v.IfMatch == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IfMatch"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateKeysInput(v *UpdateKeysInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateKeysInput"}
	if v.KvsARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KvsARN"))
	}
	if v.IfMatch == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IfMatch"))
	}
	if v.Puts != nil {
		if err := validatePutKeyRequestsList(v.Puts); err != nil {
			invalidParams.AddNested("Puts", err.(smithy.InvalidParamsError))
		}
	}
	if v.Deletes != nil {
		if err := validateDeleteKeyRequestsList(v.Deletes); err != nil {
			invalidParams.AddNested("Deletes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
