// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An error when formatting a datetime.
 *
 * Currently the only reachable error here is a missing time zone variant. If you encounter
 * that error, you need to call `with_variant` or `infer_variant` on your `TimeZoneInfo`.
 *
 * Additional information: [1](https://docs.rs/icu/latest/icu/datetime/unchecked/enum.FormattedDateTimeUncheckedError.html)
 */


export class DateTimeWriteError {
    #value = undefined;

    static #values = new Map([
        ["Unknown", 0],
        ["MissingTimeZoneVariant", 1]
    ]);

    static getAllEntries() {
        return DateTimeWriteError.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return DateTimeWriteError.#objectValues[arguments[1]];
        }

        if (value instanceof DateTimeWriteError) {
            return value;
        }

        let intVal = DateTimeWriteError.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return DateTimeWriteError.#objectValues[intVal];
        }

        throw TypeError(value + " is not a DateTimeWriteError and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new DateTimeWriteError(value);
    }

    get value(){
        return [...DateTimeWriteError.#values.keys()][this.#value];
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = [
        new DateTimeWriteError(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        new DateTimeWriteError(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
    ];

    static Unknown = DateTimeWriteError.#objectValues[0];
    static MissingTimeZoneVariant = DateTimeWriteError.#objectValues[1];


    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}