// generated by diplomat-tool
import type { Calendar } from "./Calendar"
import type { CalendarError } from "./CalendarError"
import type { IsoDate } from "./IsoDate"
import type { Rfc9557ParseError } from "./Rfc9557ParseError"
import type { Weekday } from "./Weekday"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * An ICU4X Date object capable of containing a date for any calendar.
 *
 * See the [Rust documentation for `Date`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html) for more information.
 */


export class Date {
    get ffiValue(): pointer;


    /**
     * Creates a new [`Date`] representing the ISO date
     * given but in a given calendar
     *
     * See the [Rust documentation for `new_from_iso`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.new_from_iso) for more information.
     */
    static fromIsoInCalendar(year: number, month: number, day: number, calendar: Calendar): Date;

    /**
     * Creates a new [`Date`] from the given codes, which are interpreted in the given calendar system
     *
     * An empty era code will treat the year as an extended year
     *
     * See the [Rust documentation for `try_new_from_codes`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.try_new_from_codes) for more information.
     */
    static fromCodesInCalendar(eraCode: string, year: number, monthCode: string, day: number, calendar: Calendar): Date;

    /**
     * Creates a new [`Date`] from the given Rata Die
     *
     * See the [Rust documentation for `from_rata_die`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.from_rata_die) for more information.
     */
    static fromRataDie(rd: bigint, calendar: Calendar): Date;

    /**
     * Creates a new [`Date`] from an IXDTF string.
     *
     * See the [Rust documentation for `try_from_str`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.try_from_str) for more information.
     */
    static fromString(v: string, calendar: Calendar): Date;

    /**
     * Convert this date to one in a different calendar
     *
     * See the [Rust documentation for `to_calendar`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.to_calendar) for more information.
     */
    toCalendar(calendar: Calendar): Date;

    /**
     * Converts this date to ISO
     *
     * See the [Rust documentation for `to_iso`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.to_iso) for more information.
     */
    toIso(): IsoDate;

    /**
     * Returns this date's Rata Die
     *
     * See the [Rust documentation for `to_rata_die`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.to_rata_die) for more information.
     */
    get rataDie(): bigint;

    /**
     * Returns the 1-indexed day in the year for this date
     *
     * See the [Rust documentation for `day_of_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.day_of_year) for more information.
     */
    get dayOfYear(): number;

    /**
     * Returns the 1-indexed day in the month for this date
     *
     * See the [Rust documentation for `day_of_month`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.day_of_month) for more information.
     */
    get dayOfMonth(): number;

    /**
     * Returns the day in the week for this day
     *
     * See the [Rust documentation for `day_of_week`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.day_of_week) for more information.
     */
    get dayOfWeek(): Weekday;

    /**
     * Returns 1-indexed number of the month of this date in its year
     *
     * Note that for lunar calendars this may not lead to the same month
     * having the same ordinal month across years; use month_code if you care
     * about month identity.
     *
     * See the [Rust documentation for `month`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.month) for more information.
     *
     * See the [Rust documentation for `ordinal`](https://docs.rs/icu/latest/icu/calendar/types/struct.MonthInfo.html#structfield.ordinal) for more information.
     */
    get ordinalMonth(): number;

    /**
     * Returns the month code for this date. Typically something
     * like "M01", "M02", but can be more complicated for lunar calendars.
     *
     * See the [Rust documentation for `standard_code`](https://docs.rs/icu/latest/icu/calendar/types/struct.MonthInfo.html#structfield.standard_code) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.month)
     */
    get monthCode(): string;

    /**
     * Returns the month number of this month.
     *
     * See the [Rust documentation for `month_number`](https://docs.rs/icu/latest/icu/calendar/types/struct.MonthInfo.html#method.month_number) for more information.
     */
    get monthNumber(): number;

    /**
     * Returns whether the month is a leap month.
     *
     * See the [Rust documentation for `is_leap`](https://docs.rs/icu/latest/icu/calendar/types/struct.MonthInfo.html#method.is_leap) for more information.
     */
    get monthIsLeap(): boolean;

    /**
     * Returns the year number in the current era for this date
     *
     * For calendars without an era, returns the related ISO year.
     *
     * See the [Rust documentation for `era_year_or_related_iso`](https://docs.rs/icu/latest/icu/calendar/types/enum.YearInfo.html#method.era_year_or_related_iso) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/calendar/types/struct.EraYear.html#structfield.year), [2](https://docs.rs/icu/latest/icu/calendar/types/struct.CyclicYear.html#structfield.related_iso), [3](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.year)
     */
    get eraYearOrRelatedIso(): number;

    /**
     * Returns the extended year in the Date
     *
     * See the [Rust documentation for `extended_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.extended_year) for more information.
     */
    get extendedYear(): number;

    /**
     * Returns the era for this date, or an empty string
     *
     * See the [Rust documentation for `era`](https://docs.rs/icu/latest/icu/calendar/types/struct.EraYear.html#structfield.era) for more information.
     *
     * Additional information: [1](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.year)
     */
    get era(): string;

    /**
     * Returns the number of months in the year represented by this date
     *
     * See the [Rust documentation for `months_in_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.months_in_year) for more information.
     */
    get monthsInYear(): number;

    /**
     * Returns the number of days in the month represented by this date
     *
     * See the [Rust documentation for `days_in_month`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.days_in_month) for more information.
     */
    get daysInMonth(): number;

    /**
     * Returns the number of days in the year represented by this date
     *
     * See the [Rust documentation for `days_in_year`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.days_in_year) for more information.
     */
    get daysInYear(): number;

    /**
     * Returns the [`Calendar`] object backing this date
     *
     * See the [Rust documentation for `calendar`](https://docs.rs/icu/latest/icu/calendar/struct.Date.html#method.calendar) for more information.
     */
    get calendar(): Calendar;
}