struct MegaCD : System {
  auto name() -> string override { return "Mega CD"; }
  auto load(string location) -> LoadResult override;
  auto save(string location) -> bool override;

  static constexpr u8 bram[64] = {
    0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x5f,0x00,0x00,0x00,0x00,0x40,
    0x00,0x7d,0x00,0x7d,0x00,0x7d,0x00,0x7d,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x53,0x45,0x47,0x41,0x5f,0x43,0x44,0x5f,0x52,0x4f,0x4d,0x00,0x01,0x00,0x00,0x00,
    0x52,0x41,0x4d,0x5f,0x43,0x41,0x52,0x54,0x52,0x49,0x44,0x47,0x45,0x5f,0x5f,0x5f,
  };
};

auto MegaCD::load(string location) -> LoadResult {
  auto bios = Pak::read(location);
  if(bios.empty()) return romNotFound;

  this->location = locate();
  pak = std::make_shared<vfs::directory>();
  pak->append("tmss.rom", Resource::MegaDrive::TMSS);
  pak->append("bios.rom", bios);
  pak->append("backup.ram", 8_KiB);

  if(auto fp = pak->write("backup.ram")) {
    for(auto address : range(fp->size())) fp->write(0xff);
    fp->seek(fp->size() - sizeof(bram));
    for(auto& byte : bram) fp->write(byte);
  }

  Pak::load("backup.ram", ".bram");

  return successful;
}

auto MegaCD::save(string location) -> bool {
  Pak::save("backup.ram", ".bram");

  return true;
}
